<?php

if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("admin_formcontainer_output_row", "ForumsRequirements_admin");
$plugins->add_hook("admin_forum_management_add_commit", "ForumsRequirements_save");
$plugins->add_hook("admin_forum_management_edit_commit", "ForumsRequirements_save");
$plugins->add_hook("forumdisplay_end", "ForumsRequirements_forum");
$plugins->add_hook("showthread_end", "ForumsRequirements_forum");
$plugins->add_hook("archive_start", "ForumsRequirements_archive");


function ForumsRequirements_info()
{
	return array(
		"name" => "هاك منع دخول القسم",
		"description" => "يسمح لك بتحديد اقسام معينه يمنع الدخول لها الا بعد عدد مشاركات معينه",
		"website" => "mailto:nicedo_eeos@hotmail.com",
		"author" => "Edson Ordaz",
		"authorsite" => "mailto:nicedo_eeos@hotmail.com",
		"version" => "1.0",
		"compatibility" => "16*",
		"guid" => "1501065c1ac040fd60db0eb92c9cc8fd"
	);
}

function ForumsRequirements_activate()
{

	global $db;
	$ForumsRequirements = array(
		"gid"			=> "NULL",
		"name"			=> "ForumsRequirements",
		"title" 		=> "هاك منع دخول القسم",
		"description"	=> "اعدادات الهاك",
		"disporder"		=> "0",
		"isdefault"		=> "no",
	);
	$db->insert_query("settinggroups", $ForumsRequirements);
	$gid = $db->insert_id();
	
	$ForumsRequirements_1 = array(
		"sid"			=> "NULL",
		"name"			=> "ForumsRequirements_title",
		"title"			=> "عنوان الرسالة",
		"description"	=> "ضع هنا عنوان الرسالة التي ستظهر للعضو ",
		"optionscode"	=> "text",
		"value"			=> "",
		"disporder"		=> "1",
		"gid"			=> intval($gid),
	);
	
	$ForumsRequirements_2 = array(
		"sid"			=> "NULL",
		"name"			=> "ForumsRequirements_body",
		"title"			=> "رسالة الخطأ",
		"description"	=> "ادخل هنا الرسالة التي ستظهر للعضو",
		"optionscode"	=> "textarea",
		"value"			=> "",
		"disporder"		=> "2",
		"gid"			=> intval($gid),
	);
	
	$ForumsRequirements_3 = array(
		"sid"			=> "NULL",
		"name"			=> "ForumsRequirements_archive",
		"title"			=> "رسالة خطأ الملف",
		"description"	=> "ادخل رسالة الخطأ المراد عرضها في حالة حاول الدخول للمنتدي",
		"optionscode"	=> "textarea",
		"value"			=> "",
		"disporder"		=> "3",
		"gid"			=> intval($gid),
	);
	$db->insert_query("settings", $ForumsRequirements_1);
	$db->insert_query("settings", $ForumsRequirements_2);
	$db->insert_query("settings", $ForumsRequirements_3);
	$db->query("ALTER TABLE ".TABLE_PREFIX."forums ADD ForumsRequirements INT(4) NOT NULL");
}

function ForumsRequirements_deactivate()
{

	global $db, $cache;
	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='ForumsRequirements'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='ForumsRequirements_title'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='ForumsRequirements_body'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='ForumsRequirements_archive'");
	$db->query("ALTER TABLE ".TABLE_PREFIX."forums DROP ForumsRequirements");

	$cache->update_forums();
}


function ForumsRequirements_save()
{

	global $db, $mybb, $cache;

	$ForumsRequirements_update = array(
		'ForumsRequirements' => abs(floatval($mybb->input['ForumsRequirements']))
	);
	$db->update_query("forums", $ForumsRequirements_update, "fid='".intval($mybb->input['fid'])."'");

	$cache->update_forums();
}



function ForumsRequirements_admin(&$formvars)
{

	global $mybb, $forum_data, $form, $form_container, $cache, $lang;

	$ForumsRequirements = $cache->cache['forums'][$mybb->input['fid']]['ForumsRequirements'];

	if($formvars['title'] === $lang->forum_link && $lang->forum_link)
	{

		$form_container->output_row("Forums Requirements", "Post minimos requeridos para tener accesso a este foro", $form->generate_text_box('ForumsRequirements', $ForumsRequirements, array('id' => 'ForumsRequirements')), 'ForumsRequirements');

	}


}

function ForumsRequirements_forum()
{

	global $mybb;

	global $forum_cache, $fid, $forum;
	$title_error = $mybb->settings['ForumsRequirements_title'];
	$body_error = $mybb->settings['ForumsRequirements_body'];
	if(intval($mybb->user['postnum']) < $forum_cache[$fid]['ForumsRequirements'])
	{

		$title = $title_error;
		$message = $body_error; 
		$message = preg_replace("!\[ForumsRequirements\]!Us", $forum_cache[$fid]['ForumsRequirements'], $message);
		error($message,$title);

	}

}

function ForumsRequirements_archive()
{

	global $mybb, $forum;
	$body_archive = $mybb->settings['ForumsRequirements_archive'];
	if(intval($mybb->user['postnum']) < $forum['ForumsRequirements'])
	{

		$body_archive = preg_replace("!\[ForumsRequirements\]!Us", $forum['ForumsRequirements'], $body_archive);
		archive_error($body_archive);

	}

}

?>